package book.beans;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.inject.Named;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 *
 * @author Leonard
 */
@Named
@RequestScoped
public class PlayersBean {

    private static final Logger logger = Logger.getLogger(PlayersBean.class.getName());
    
    @NotNull(message = "Imię nie może być puste (ani być wartością null)")
     @Size(min = 3,message = "Imię musi zawierać co najmniej trzy litery")
    private String playerName;
    
    @NotNull(message = "Nazwisko nie może być puste (ani być wartością null)")
    @Size(min = 3,message = "Nazisko musi zawierać co najmniej trzy litery")
    private String playerSurname;

    public String getPlayerName() {
        return playerName;
    }

    public void setPlayerName(String playerName) {
        logger.log(Level.INFO, "Pomyślnie sprawdzono poprawność imienia ({0}) zawodnika!", playerName);
        this.playerName = playerName;
    }

    public String getPlayerSurname() {
        return playerSurname;
    }

    public void setPlayerSurname(String playerSurname) {
        logger.log(Level.INFO, "Pomyślnie sprawdzono poprawność nazwiska ({0}) zawodnika", playerSurname);
        this.playerSurname = playerSurname;
    }

    public void playerAction() {
        logger.log(Level.INFO, "Imię zawodnika: {0}", playerName);
        logger.log(Level.INFO, "Nazwisko zawodnika: {0}", playerSurname);
    }
}
